Create or Replace PACKAGE UTIL IS

   PROCEDURE ChangeMapToAlkindi (
      iRight_Product_id in Number,
      iWrong_Product_Id in Number,
      iCoreProductTH in number default 30
   );

   PROCEDURE MergeProducts (
      iRight_Product_id in Number,
      iWrong_Product_Id in Number,
      iCoreProductTH in number default 30
   );

   PROCEDURE CleanUpUserId (
      iUser_Id in Number                        -- the User_Id we want to delete
   );

   PROCEDURE MergeUsers (
      iNew_User_id in Number,	 				 -- the User_Id we want to keep
      iOld_User_Id in Number 					 -- the User_Id we want to get rid of
   );

   PROCEDURE PC_for_old_Recs;

END UTIL;
/

Create or Replace PACKAGE BODY UTIL AS

--
-- Change the mapping of a product mapped without evaluations or recommendations to
-- a product (same movie title) not mapped yet, with evaluations
--
PROCEDURE ChangeMapToAlkindi (
   iRight_Product_id in Number,						 -- the Product_Id we want to keep
   iWrong_Product_Id in Number, 					 -- the Product_Id we want to get rid of
   iCoreProductTH in number default 30				 -- the minimum number of ratings to be considered a Core Product
) IS
   vRatings			   NUMBER; -- number of evaluations > 0 of iRight_Product_Id
   vLast_Product_Index NUMBER;
BEGIN

   UPDATE Map_Product
   SET
      Product_Id = iRight_Product_Id
   WHERE
      Product_Id = iWrong_Product_Id;

   -- get the number of ratings of the right product --
   SELECT
      count(*)
   INTO
      vRatings
   FROM
      Evaluation e
   WHERE
      e.Product_id = iRight_Product_Id AND
	  e.Evaluation_Scale_Id > 0;

   if (vRatings > 0) then
   -- if the product is "Selectable" --
      INSERT INTO Rel_Product_Cluster (
	     Product_Cluster_Id,
		 Product_Id
	  )
	  SELECT distinct
		 mappc.Product_Category_Id,
	     mapp.Product_Id
      FROM
         Map_Product mapp,
         MUZE.ProdCategory mpc,
         Map_Product_Category mappc
      WHERE
         mapp.Product_Id = iRight_Product_Id AND
         mpc.Muzeid = mapp.Mapped_Product_Id AND
         mappc.Mapped_Category_Id = mpc.CategoryId;
   end if;

   DELETE Movie
   WHERE
      Product_Id = iWrong_Product_Id;

   DELETE Product
   WHERE
      Product_Id = iWrong_Product_Id;

END ChangeMapToAlkindi;

--
-- Merge products with the same mapping
--
PROCEDURE MergeProducts (
   iRight_Product_id in Number,						 -- the Product_Id we want to keep
   iWrong_Product_Id in Number, 					 -- the Product_Id we want to get rid of
   iCoreProductTH in number default 30				 -- the minimum number of ratings to be considered a Core Product
) IS
   vMapped_Product_Id  NUMBER;
   vRatings			   NUMBER; -- number of evaluations > 0 of iRight_Product_Id
   vLast_Product_Index NUMBER;
BEGIN
   -- get the Mapped_Product_Id
   SELECT
      unique Mapped_Product_Id
   INTO
      vMapped_Product_Id
   FROM
      Map_Product m
   WHERE
      M.Product_Id = iRight_Product_Id or
	  M.Product_Id = iWrong_Product_Id;

   -- change Product_Id --
   DELETE Evaluation
   WHERE
      Product_Id = iWrong_Product_Id and
	  User_Id in (
         SELECT
		    User_Id
		 FROM
		    Evaluation
	     WHERE Product_Id in (iRight_Product_Id, iWrong_Product_Id)
         GROUP BY User_Id
		 HAVING count(*) > 1);

   UPDATE Evaluation
   SET
      Product_Id = iRight_Product_Id
   WHERE
      Product_Id = iWrong_Product_Id;

   DELETE Recommendation
   WHERE
      Product_Id = iWrong_Product_Id and
	  User_Id in (
         SELECT
		    User_Id
		 FROM
		    Recommendation
	     WHERE Product_Id in (iRight_Product_Id, iWrong_Product_Id)
         GROUP BY User_Id
		 HAVING count(*) > 1);

   UPDATE Recommendation
   SET
      Product_Id = iRight_Product_Id
   WHERE
      Product_Id = iWrong_Product_Id;

   UPDATE User_My_List
   SET
      Product_Id = iRight_Product_Id
   WHERE
      Product_Id = iWrong_Product_Id;

   UPDATE User_Product_Review
   SET
      Product_Id = iRight_Product_Id
   WHERE
      Product_Id = iWrong_Product_Id;

   -- Delete --
   DELETE Prod_Stat
   WHERE
      Product_Id in (iRight_Product_Id, iWrong_Product_Id);

   DELETE Prod_PC_Stat
   WHERE
      Product_Id in (iRight_Product_Id, iWrong_Product_Id);

   DELETE Prod_UC_Stat
   WHERE
      Product_Id in (iRight_Product_Id, iWrong_Product_Id);

   DELETE Rel_Product_Cluster
   WHERE
      Product_Id in (iRight_Product_Id, iWrong_Product_Id);

   -- get the number of ratings of the right product --
   SELECT
      count(*)
   INTO
      vRatings
   FROM
      Evaluation e
   WHERE
      e.Product_id = iRight_Product_Id AND
	  e.Evaluation_Scale_Id > 0;

   if (vRatings > 0) then
   -- if the product is "Selectable" --
      INSERT INTO Rel_Product_Cluster (
	     Product_Cluster_Id,
		 Product_Id
	  )
	  SELECT distinct
		 mappc.Product_Category_Id,
	     mapp.Product_Id
      FROM
         Map_Product mapp,
         MUZE.ProdCategory mpc,
         Map_Product_Category mappc
      WHERE
         mapp.Product_Id = iRight_Product_Id AND
         mpc.Muzeid = mapp.Mapped_Product_Id AND
         mappc.Mapped_Category_Id = mpc.CategoryId;

   end if;

   DELETE Map_Product
   WHERE
      Product_Id = iWrong_Product_Id;

   DELETE Movie
   WHERE
      Product_Id = iWrong_Product_Id;

   DELETE Product
   WHERE
      Product_Id = iWrong_Product_Id;

END MergeProducts;


PROCEDURE CleanUpUserId (
   iUser_Id in Number                        -- the User_Id we want to delete
) IS
BEGIN
   DELETE User_Other_Entry
   WHERE
      User_Id = iUser_Id;

   DELETE User_Friend_Email
   WHERE
      User_Id = iUser_Id;

   DELETE User_Stat
   WHERE
      User_Id = iUser_Id;

   DELETE User_SF_Stat
   WHERE
      User_Id = iUser_Id;

   DELETE User_My_List
   WHERE
      User_Id = iUser_Id;

   DELETE User_Product_Review
   WHERE
      User_Id = iUser_Id;

   DELETE Rel_User_Cluster
   WHERE
      User_Id = iUser_Id;

   DELETE Evaluation
   WHERE
      User_Id = iUser_Id;

   DELETE Recommendation
   WHERE
      User_Id = iUser_Id;

   DELETE User_Detail
   WHERE
      User_Id = iUser_Id;

   DELETE User_Id
   WHERE
      User_Id = iUser_Id;

END CleanUpUserId;


PROCEDURE MergeUsers (
   iNew_User_id in Number,	 				 -- the User_Id we want to keep
   iOld_User_Id in Number 					 -- the User_Id we want to get rid of
) IS
   vMapped_Product_Id  NUMBER;
   vRatings			   NUMBER; -- number of evaluations > 0 of iRight_Product_Id
   vLast_Product_Index NUMBER;
BEGIN

   DELETE User_Stat
   WHERE
      User_Id = iOld_User_Id;

   DELETE User_SF_Stat
   WHERE
      User_Id = iOld_User_Id;

   DELETE Rel_User_Cluster
   WHERE
      User_Id = iOld_User_Id;

   DELETE Recommendation
   WHERE
      User_Id = iOld_User_Id;

   DELETE Evaluation E
   WHERE
      User_Id = iOld_User_Id and
      exists (select 'x'
	          from Evaluation E1
			  where E1.Product_Id = E.Product_Id and E1.User_Id = iNew_User_Id);

   UPDATE Evaluation
   SET User_Id = iNew_User_Id
   WHERE
      User_Id = iOld_User_Id;

   DELETE User_Detail
   WHERE
      User_Id = iOld_User_Id;

   DELETE User_Id
   WHERE
      User_Id = iOld_User_Id;

END MergeUsers;

PROCEDURE PC_for_old_Recs
IS
  cursor cRec is
    select * from RECOMMENDATION for update of product_cluster_id;

  cursor cRecLog is
    select * from RECOMMENDATION_LOG for update of product_cluster_id;

   vMapped_Product_Id  NUMBER;
   vRatings			   NUMBER; -- number of evaluations > 0 of iRight_Product_Id
   vLast_Product_Index NUMBER;
BEGIN

  for rRec in cRec
  loop

    update RECOMMENDATION set (
      product_cluster_id
    ) = (
      select product_cluster_id
      from
        (
          select
            RPC.product_cluster_id,
            PCS.wgt_tot_prod_in_pc * ( exp( UPCS.avg_prod_rat ) ) i
          from
            USER_PC_STAT UPCS,
            PC_STAT PCS,
            RECOMMENDABLE_PROD_CLUSTER RPC
          where
            UPCS.user_id = rRec.user_id AND
            RPC.product_id = rRec.product_id AND
            UPCS.product_cluster_id = RPC.product_cluster_id AND
            PCS.product_cluster_id = UPCS.product_cluster_id
          order by
            i desc
        )
      where
        rownum = 1
    )
    where current of cRec;

  end loop;

  for rRecLog in cRecLog
  loop

    update RECOMMENDATION_LOG set (
      product_cluster_id
    ) = (
      select product_cluster_id
      from
        (
          select
            RPC.product_cluster_id,
            PCS.wgt_tot_prod_in_pc * ( exp( UPCS.avg_prod_rat ) ) i
          from
            USER_PC_STAT UPCS,
            PC_STAT PCS,
            RECOMMENDABLE_PROD_CLUSTER RPC
          where
            UPCS.user_id = rRecLog.user_id AND
            RPC.product_id = rRecLog.product_id AND
            UPCS.product_cluster_id = RPC.product_cluster_id AND
            PCS.product_cluster_id = UPCS.product_cluster_id
          order by
            i desc
        )
      where
        rownum = 1
    )
    where current of cRecLog;

  end loop;

END PC_for_old_Recs;


END UTIL;
/
